/**********
* File: CDGL_IDirect3D9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DResource9. 
					 This class is the concrete implementation of IDirect3DResource9 interface. The IDirect3DResource9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 17Mar05

* Change History (Most Recent First):

**********/


#ifndef __CDGL_IDIRECT3DRESOURCE9_H__
#define __CDGL_IDIRECT3DRESOURCE9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"

class CDGL_IDirect3DResource9 : public IDirect3DResource9
{
	public:
			CDGL_IDirect3DResource9(IDirect3DDevice9 *in_pDevice);
			~CDGL_IDirect3DResource9();
			
			/*** IUnknown methods ***/
			virtual HRESULT QueryInterface( REFIID riid, void** ppvObj) = 0;
			virtual ULONG AddRef() = 0;
			virtual ULONG Release() = 0;

			/*** IDirect3DResource9 methods ***/
			virtual HRESULT GetDevice( IDirect3DDevice9** ppDevice) = 0;
			virtual HRESULT SetPrivateData( REFGUID refguid,CONST void* pData,DWORD SizeOfData,DWORD Flags) = 0;
			virtual HRESULT GetPrivateData( REFGUID refguid,void* pData,DWORD* pSizeOfData) = 0;
			virtual HRESULT FreePrivateData( REFGUID refguid) = 0;
			virtual DWORD SetPriority( DWORD PriorityNew) = 0;
			virtual DWORD GetPriority() = 0;
			virtual void PreLoad() = 0;
			virtual D3DRESOURCETYPE GetType() = 0;
	
	protected:
	
			IDirect3DDevice9 *		m_pDevice;	
			DWORD					m_lPriority;	
			//Shilpa - i am not sure if these are required...anyway we are not giving implemetnation of the functions of this class these were present in original RVR code!!
			/*int						m_Width;
			int						m_Height;
			D3DFORMAT				m_Format;
			D3DMULTISAMPLE_TYPE		m_mstype;
			int						m_refCount;
			void			*		m_pLocalData;
			RECT					m_rectLock;
			DWORD					m_flagsLock;*/
	
};


#endif //__CDGL_IDIRECT3DRESOURCE9_H__

